(* dodatne funkcije koje koristimo *)
fun duzina(lista) = if(null(lista)) then 0
	else 1 + duzina(tl(lista));

(* prvi zadatak *)
fun pozicija1(x, lista, i) = if(null(lista)) then []
	else if(hd(lista) = x) then i::pozicija1(x, tl(lista), i+1)
	else pozicija1(x, tl(lista), i+1);

fun pozicija(x, lista) = pozicija1(x, lista, 1);

(* drugi zadatak *)
fun qsort [] = []
  | qsort (x::xs) =
    let 
        val (left, right) = List.partition (fn y => y<x) xs
    in
        qsort left @ [x] @ qsort right
    end

(* treci zadatak *)
fun brisiPonavljanja1(lista, i) = if(null(lista)) then []
	else if(i = hd(lista)) then brisiPonavljanja1(tl(lista), i)
	else hd(lista)::brisiPonavljanja1(tl(lista), hd(lista));

fun brisiPonavljanja(lista) = if(null(lista)) then []
	else hd(lista)::brisiPonavljanja1(tl(lista), hd(lista))

(* cetvrti zadatak *)
fun nadjiPodlistu(lista, el) = if(null(lista)) then []
	else if(hd(lista) = el) then el::nadjiPodlistu(tl(lista), el)
	else [];

fun podlistePonavljanja1(lista, el) = if(null(lista)) then []
	else if(hd(lista) = el) then podlistePonavljanja1(tl(lista), el)
	else nadjiPodlistu(lista, hd(lista))::podlistePonavljanja1(tl(lista), hd(lista));

fun podlistePonavljanja(lista) = if(null(lista)) then []
	else nadjiPodlistu(lista, hd(lista))::podlistePonavljanja1(tl(lista), hd(lista));

(* peti zadatak *)
fun provjeraDuplikata(lista, el) = if(null(lista)) then 0
	else if(hd(lista) = el) then 1
	else provjeraDuplikata(tl(lista), el);

fun imaDuplikata(lista) = if(null(lista)) then false
	else if(provjeraDuplikata(tl(lista), hd(lista)) = 1) then true
	else imaDuplikata(tl(lista));

(* sesti zadatak *)
fun uzastopniParovi1(prethodni, lista) = if(duzina(lista) = 1) then [(prethodni, hd(lista))]
	else (prethodni, hd(lista))::uzastopniParovi1(hd(lista), tl(lista));

fun uzastopniParovi(lista) = uzastopniParovi1(hd(lista), tl(lista));

(* sedmi zadatak *)
fun broj(lista) = if(null(lista)) then 0
	else if(duzina(lista) = 1) then hd(lista)
	else hd(lista) + 10 * broj(tl(lista));

(* osmi zadatak *)
fun brojPomocna(suma, lista) = if(null(lista)) then suma
	else brojPomocna((suma*10 + hd(lista)), tl(lista));

fun broj1(lista) = brojPomocna(0, lista);
